* ==============================================================================
* Date	: 08 - 11 - 2019
* Paper	: The heterogeneous effects of standards on agrifood trade 
* Author: Dela-Dem Doe Fiankor, Oliver Ken-Haase, Bernhard Brümmer
* E-mail: dfianko@agr.uni-goettingen.de
* ==============================================================================

* Program Setup
	version 15              				
	set more off            				
	clear all               				
	set linesize 80        				 	
	macro drop _all         				
	capture log close       				
	log using translog.txt, text replace
* ==============================================================================

* Data Files	
	global wd		"/Users/ddfiankor/ownCloud/Projects/Ongoing/Translog gravity/data"
	global baci		"/Users/ddfiankor/ownCloud/Data/baci"
	global tariff	"/Users/ddfiankor/ownCloud/Data/tariff"
	global comtrade	"$wd/comtrade"
	global ntm		"$wd/ntm"
	
* ==============================================================================

* Bilateral trade data - BACI

use "$baci/baci96/baci96", clear 
  gen hs2 = int(hs6/10000)
  drop if hs2 >24 		// keep only agricultural products	
  merge m:1 i using "$baci/baci96/country_code_baci96.dta",   keep(3) nogen  // BACI country codes are numbers but the other datasets have names, so we merge country names
  rename name partnername
  gen exp = partnername
  merge m:1 j using "$baci/baci96/country_code_baci96_j.dta", keep(3) nogen  
  rename name reportername
  gen imp = reportername
  do countrynames
  drop i j 
  rename (exp imp) (i j)
  order i j hs6 t 
preserve 
  bys i t hs2:  gen nhs2  = _n == 1 // * We generate two different measures of the extensive margins (n_i in Novy)
  bys i t hs6:  gen nhs6  = _n == 1 
  bys i t    : egen n2_it       = sum(nhs2)
  bys i t    : egen n6_it       = sum(nhs6)
  keep i t n2_it n6_it
  duplicates drop
  save ext_margin, replace
restore
	
foreach c of varlist v q {  // Aggregating the data to the country level (dropping the product dimension) 
  bys i j t: egen  `c'_n = sum(`c')
}
  drop hs2 hs6 v q 
  duplicates drop 
* To avoid dealing with EU expansion, we treat the EU-15 as a group
  gen  byte eu15 = (j=="FRA"|j=="DEU"|j=="ITA"|j=="NLD"|j=="BEL"|j=="BLX"|j=="LUX"|j=="GBR"|j=="DNK"|j=="IRL"|j=="ESP"|j=="PRT"|j=="GRC"|j=="AUT"|j=="SWE"|j=="FIN")
  bys  i t: egen v_eu15 = sum(v) if eu15 == 1
  replace v_n = v_eu15 if j == "DEU"
  drop if (j=="FRA" |j=="ITA" |j=="NLD" |j=="BEL"| j=="BLX" |j=="LUX" |j=="GBR" |j=="DNK" |j=="IRL"|j=="ESP" |j=="PRT" |j=="GRC"  |j=="AUT" |j=="SWE" |j=="FIN")
  replace j = "EU15" if j == "DEU"
  drop eu15 v_eu15
  fillin i j t  // To balance the panel and generate zero trade observations we fillin
  merge m:1 i t using ext_margin, nogen 
  drop 	_fillin
  renvars v_n q_n / v q 
  replace v = 0 if v == .
  replace q = 0 if q == .
	
*2. We a generate a second measure of n_i following Hummels and Klenow
	*drop if i == j
	*replace v = 0 if v == .
	*bys j: egen avg = mean(v) 	 // Average imports of product k to the importer over all years 
	*bys j: gen n = _n			
	*egen n_hs6 = total(avg) if n==1
	*egen denominator_ext = mean(n_hs6)
	*bys i j t: egen numerator_ext = total(avg)
	*gen n_i		= numerator_ext / denominator_ext if v>0
	*replace n_i = 0 if n_i == .
	
* BACI has Belgium-Luxembourg instead of Belgium & Luxembourg
  replace i = "BEL" if i == "BLX"	
  replace j = "BEL" if j == "BLX"
  *drop avg n n_hs6 denominator_ext numerator_ext
  order i j t
  sort  i j t
save "$wd/baci96", replace

* Ghodsi Data 
use accu_nwld_95_17, clear
  gen hs2 = substr(Product,1,2) 
  destring hs2, force replace
  drop if hs2 > 24
  renvars ImporterISO3 ExporterISO3 Year / j i t
  keep i j t SPSSTC
foreach c of varlist SPSSTC {
  bys i j t: egen  `c'_n = total(`c')
}
  drop SPSSTC
  rename SPSSTC_n sps
  duplicates drop
  replace j = "EU15" if j == "DEU"
  drop if (j=="FRA" |j=="ITA" |j=="NLD" |j=="BEL"| j=="BLX" |j=="LUX" |j=="GBR" |j=="DNK" |j=="IRL"|j=="ESP" |j=="PRT" |j=="GRC"  |j=="AUT" |j=="SWE" |j=="FIN")
save ntm, replace
	
* Tariffs
import delimited tariff_wto, varnames(1) clear
  keep reportername partnername tariffyear dutytype simpleaverage weightedaverage
  renvars reportername partnername / imp exp 
  do countrynames
  renvars imp exp tariffyear simpleaverage / j i t tariff
  replace j = "EU15" if j == "European Union"
  drop if (j=="FRA" |j=="ITA" |j=="NLD" |j=="BEL"| j=="BLX" |j=="LUX" |j=="GBR" |j=="DNK" |j=="IRL"|j=="ESP" |j=="PRT" |j=="GRC"  |j=="AUT" |j=="SWE" |j=="FIN" |j=="DEU")
  save tariff_wb, replace

  keep if j == "EU15"
  expgen = 13 if j == "EU15", copy(EU)
  replace j = "HUN" if EU == 1  & t >= 2004
  replace j = "LVA" if EU == 2  & t >= 2004
  replace j = "LTU" if EU == 3  & t >= 2004
  replace j = "POL" if EU == 4  & t >= 2004
  replace j = "SVK" if EU == 5  & t >= 2004
  replace j = "SVN" if EU == 6  & t >= 2004
  replace j = "MLT" if EU == 7  & t >= 2004
  replace j = "CZE" if EU == 8  & t >= 2004
  replace j = "EST" if EU == 9  & t >= 2004
  replace j = "CYP" if EU == 10 & t >= 2004
  replace j = "BGR" if EU == 11 & t >= 2007
  replace j = "ROU" if EU == 12 & t >= 2007
  replace j = "HRV" if EU == 13 & t >= 2013
  drop if EU == 1  & t < 2004
  drop if EU == 2  & t < 2004
  drop if EU == 3  & t < 2004
  drop if EU == 4  & t < 2004
  drop if EU == 5  & t < 2004
  drop if EU == 6  & t < 2004
  drop if EU == 7  & t < 2004
  drop if EU == 8  & t < 2004
  drop if EU == 9  & t < 2004
  drop if EU == 10 & t < 2004
  drop if EU == 11 & t < 2007
  drop if EU == 12 & t < 2007
  drop if EU == 13 & t < 2014
  append using tariff_wb
  drop EU 
  encode dutytype, gen(duty) 
  drop dutytype 
  reshape wide tariff weightedaverage, j(duty) i(i j t)
  renvars tariff1 tariff2 tariff3 / tariff_ahs tariff_bnd tariff_mfn 
  drop weight*
  save tariff, replace
	
****************************** DATA ANALYSIS ***********************************
use baci96, clear
  merge 1:m i j t using ntm, 	  keep(3) nogen 
 *merge m:1 j t   using ntm_j,  keep(1 3) nogen 
  merge 1:m i j t using rta,    keep(1 3)   nogen 	
  merge 1:m i j t using tariff, keep(1 3) nogen 
  gen int tariff = .  
  replace tariff = tariff_ahs
  replace tariff = tariff_mfn if tariff == .
  replace tariff = tariff_bnd if tariff == . 
  gen byte eu24i = (i=="CYP" & t>= 2004|i=="CZE" & t >= 2004|i=="EST" & t >= 2004|i=="HUN" & t >= 2004|i=="LVA" & t >= 2004 |i=="LTU" & t >= 2004|i=="MLT" & t >= 2004|i=="POL" & t>= 2004|i=="SVN" & t >= 2004|i=="SVK" & t >= 2004|i=="BGR" & t >= 2007|i=="ROU" & t >= 2007|i=="HRV" & t >= 2013)
  gen byte eu24j = (j=="CYP" & t>= 2004|j=="CZE" & t >= 2004|j=="EST" & t >= 2004|j=="HUN" & t >= 2004|j=="LVA" & t >= 2004 |j=="LTU" & t >= 2004|j=="MLT" & t >= 2004|j=="POL" & t>= 2004|j=="SVN" & t >= 2004|j=="SVK" & t >= 2004|j=="BGR" & t >= 2007|j=="ROU" & t >= 2007|j=="HRV" & t >= 2013)
  gen byte eu15i = (i=="FRA" |i=="ITA" |i=="NLD" |i=="BEL"| i=="BLX" |i=="LUX" |i=="GBR" |i=="DNK" |j=="IRL"|i=="ESP" |i=="PRT" |i=="GRC"  |i=="AUT" |i=="SWE" |i=="FIN" |i=="DEU")
  replace tariff = 0 if j == "EU15" & eu24i == 1
  replace tariff = 0 if eu15 == 1 & eu24j == 1
  replace tariff = 0 if j == "EU15" & eu15 == 1
  bys i j (t) : carryforward(tariff), replace
  bys i t: egen new = max(tariff)  
  replace tariff = new if tariff == . 
  drop if (i=="SDN"|i=="YUG")
  *drop if j == "EU15" & eu15i == 1 // Drop intra EU trade? 	
keep i j t v q n2_it n6_it sps rta tariff // partnername reportername
foreach i of varlist sps v {
  replace `i' = 0 if `i' == .
}
  compress 
  save translog_gravity, replace 
	
****************************** REGRESSIONS *************************************
use translog_gravity, clear
*We include only bilateral pairs where an STC was active at least one year 
	bys i: egen sps_i = total(sps)
	bys j: egen sps_j = sum(sps)
	drop if sps_i == 0 
	drop if sps_j == 0
	drop sps_i sps_j
***
	egen id = group(i j)
	xtset id t
	 
	 gen      lsps = log(1 + sps)
	 gen byte dsps = sps > 0

	 gen ltariff = log(1 + tariff) 
	 gen lv		 = log(v)
	egen it 	 = group(i t) 
	egen jt 	 = group(j t) 
	egen ij  	 = group(i j)
	
* TRANSLOG GRAVITY
	
	bys j t: egen y_jt = sum(v)
	drop if y_jt == 0
	gen s_ijt = [(v / y_jt) / n2_it] * 100  // generate import shares
	gen share =  (v / y_jt) * 100 // generate import shares

	global xijt 
	eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
	eststo:  reghdfe s_ijt dsps ltariff rta,			 absorb(jt it ij) cluster(id)
	eststo: ppmlhdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
	eststo: ppmlhdfe s_ijt dsps ltariff rta,			 absorb(jt it ij) cluster(id)
	
	outreg2 [*] using translog.xls, dec(3) replace
	drop _est*
	erase translog.txt
	

* CES WITH HOMOGENEOUS EFFECTS
	eststo: ppmlhdfe  v dsps ltariff rta, absorb(jt it ij) cluster(id)
			ppmlhdfe  v,       absorb(jt it ij) cluster(id) d
			gen predictedshares = v - _ppmlhdfe_d // difference between the actual value and residual
			gen dsps_sharehat = dsps * predictedshares
	eststo: ppmlhdfe  v $xijt dsps_sharehat, 			absorb(jt it ij) cluster(id)
			xtile interval = predictedshares, nquantiles(4) 
			tab interval, gen(share_interval)
			gen dsps_interval1 = dsps*share_interval1
			gen dsps_interval2 = dsps*share_interval2
			gen dsps_interval3 = dsps*share_interval3
			gen dsps_interval4 = dsps*share_interval4
	eststo: ppmlhdfe  v dsps_interval1 dsps_interval2 dsps_interval3 dsps_interval4 ltariff rta ,absorb(jt it ij) cluster(id)

	outreg2 [*] using ces.xls, dec(3) replace
	drop _est*
	erase ces.txt

****************************** DESCRIPTIVES ************************************

*gen elasticities = (_b[mrl]) / share_ijkt
	
	preserve
	reghdfe s_ijt dsps ltariff rta, absorb(jt it ij) cluster(id)
	*ppmlhdfe s_ijt dsps ltariff rta, absorb(jt it ij) cluster(id)

	*gen share = s_ijt * 100
	drop if dsps == 0
	drop if s_ijt == 0
	bys i j: egen new = sum(sps)
	drop if new == 0
	gen elasticity = ((_b[dsps]) / s_ijt)
	
	order i j t v share elasticity
	sort share
	keep i j t v share elasticity
	keep if j == "EU15" & t == 2017
	*collapse elasticities s_ijt, by(i j t)
	
	*graph twoway scatter elasticities s_ijt if j == "EU15"  & t  == 2010  & s_ijt>0.6
	
egen p10 = pctile(s_ijt), p(10)
egen p15 = pctile(s_ijt), p(15)
egen p20 = pctile(s_ijt), p(20)
egen p25 = pctile(s_ijt), p(25)
egen p30 = pctile(s_ijt), p(30)
egen p35 = pctile(s_ijt), p(35)
egen p40 = pctile(s_ijt), p(40)
egen p45 = pctile(s_ijt), p(45)
egen p50 = pctile(s_ijt), p(50)
egen p55 = pctile(s_ijt), p(55)
egen p60 = pctile(s_ijt), p(60)
egen p65 = pctile(s_ijt), p(65)
egen p70 = pctile(s_ijt), p(70)
egen p75 = pctile(s_ijt), p(75)
egen p80 = pctile(s_ijt), p(80)
egen p85 = pctile(s_ijt), p(85)
egen p90 = pctile(s_ijt), p(90)


centile s_ijt, centile(10(5)90) 

gen elasticities10 = (_b[dsps]) / p10
gen elasticities15 = (_b[dsps]) / p15
gen elasticities20 = (_b[dsps]) / p20
gen elasticities25 = (_b[dsps]) / p25
gen elasticities30 = (_b[dsps]) / p30
gen elasticities35 = (_b[dsps]) / p35
gen elasticities40 = (_b[dsps]) / p40
gen elasticities45 = (_b[dsps]) / p45
gen elasticities50 = (_b[dsps]) / p50
gen elasticities55 = (_b[dsps]) / p55
gen elasticities60 = (_b[dsps]) / p60
gen elasticities65 = (_b[dsps]) / p65
gen elasticities70 = (_b[dsps]) / p70
gen elasticities75 = (_b[dsps]) / p75
gen elasticities80 = (_b[dsps]) / p80
gen elasticities85 = (_b[dsps]) / p85
gen elasticities90 = (_b[dsps]) / p90

gen elasticities10ul = (_b[dsps]) / .0002473
gen elasticities15ul = (_b[dsps]) / .0005435
gen elasticities20ul = (_b[dsps]) / .0010642
gen elasticities25ul = (_b[dsps]) / .0017488
gen elasticities30ul = (_b[dsps]) / .0026019
gen elasticities35ul = (_b[dsps]) / .003752
gen elasticities40ul = (_b[dsps]) / .0051746
gen elasticities45ul = (_b[dsps]) / .0073258
gen elasticities50ul = (_b[dsps]) / .0101216
gen elasticities55ul = (_b[dsps]) / .0143043
gen elasticities60ul = (_b[dsps]) / .0196982
gen elasticities65ul = (_b[dsps]) / .0267714
gen elasticities70ul = (_b[dsps]) / .0345076
gen elasticities75ul = (_b[dsps]) / .0457166
gen elasticities80ul = (_b[dsps]) / .0637082
gen elasticities85ul = (_b[dsps]) / .0894186
gen elasticities90ul = (_b[dsps]) / .1332771

gen elasticities10ll = (_b[dsps]) / .0002042
gen elasticities15ll = (_b[dsps]) / .0004582
gen elasticities20ll = (_b[dsps]) / .000917
gen elasticities25ll = (_b[dsps]) / .0015427
gen elasticities30ll = (_b[dsps]) / .0023009
gen elasticities35ll = (_b[dsps]) / .0033684
gen elasticities40ll = (_b[dsps]) / .004648
gen elasticities45ll = (_b[dsps]) / .006508
gen elasticities50ll = (_b[dsps]) / .0091271 
gen elasticities55ll = (_b[dsps]) / .0126054 
gen elasticities60ll = (_b[dsps]) / .0177754
gen elasticities65ll = (_b[dsps]) / .0243783
gen elasticities70ll = (_b[dsps]) / .0315568
gen elasticities75ll = (_b[dsps]) / .0420176
gen elasticities80ll = (_b[dsps]) / .0577755
gen elasticities85ll = (_b[dsps]) / .0809327
gen elasticities90ll = (_b[dsps]) / .1217579

keep elasticiti*
duplicates drop 

**
sort i 
count if i[_n] != i[_n-1]
sort j 
count if j[_n] != j[_n-1]

**APPENDIX 
* Using the one year lag of SPS measures
 bys i j (t): gen ldsps = dsps[_n-1]
 eststo:  reghdfe s_ijt ldsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
 eststo:  reghdfe s_ijt ldsps ltariff rta,			 absorb(jt it ij) cluster(id)
 eststo: ppmlhdfe s_ijt ldsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
 eststo: ppmlhdfe s_ijt ldsps ltariff rta,			 absorb(jt it ij) cluster(id)
	
	outreg2 [*] using translog_lag.xls, dec(3) replace
	drop _est*
	erase translog_lag.txt
	
** CES
 eststo:  reghdfe lv dsps ltariff rta, absorb(jt it ij) cluster(id)
 eststo: ppmlhdfe  v dsps ltariff rta if v>0, absorb(jt it ij) cluster(id)
 eststo: ppmlhdfe  v dsps ltariff rta, absorb(jt it ij) cluster(id)
 
 outreg2 [*] using ces_appendix.xls, dec(3) replace
	drop _est*
	erase ces_appendix.txt
	
** Number of countries targeted by at least one SPS concern across t
drop if sps == 0
bys i t: gen newi = _n
keep t newi
duplicates drop
bys t: egen new = max(newi)

** mean effects
use translog_gravity, clear
*We include only bilateral pairs where an STC was active at least one year 
	bys i: egen sps_i = total(sps)
	bys j: egen sps_j = sum(sps)
	drop if sps_i == 0 
	drop if sps_j == 0
	drop sps_i sps_j
***
	egen id = group(i j)
	xtset id t
	 
	 gen      lsps = log(1 + sps)
	 gen byte dsps = sps > 0
	 bys i j (t): gen ldsps = dsps[_n-1]


	 gen ltariff = log(1 + tariff) 
	 gen lv		 = log(v)
	egen it 	 = group(i t) 
	egen jt 	 = group(j t) 
	egen ij  	 = group(i j)
	bys j t: egen y_jt = sum(v)
	drop if y_jt == 0
	gen s_ijt = [(v / y_jt) / n2_it] * 100  // generate import shares
	gen share =  (v / y_jt) * 100 // generate import shares

	
preserve 
reghdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
*reghdfe s_ijt dsps ltariff rta, absorb(jt it ij) cluster(id)
*ppmlhdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
*ppmlhdfe s_ijt dsps ltariff rta, absorb(jt it ij) cluster(id)


		gen elasticity = ((_b[dsps]) / s_ijt)
		drop if elasticity ==. 
		egen p10 = pctile(s_ijt), p(10)
		egen p20 = pctile(s_ijt), p(20)
		egen p30 = pctile(s_ijt), p(30)
		egen p50 = pctile(s_ijt), p(50)
		egen p90 = pctile(s_ijt), p(90)
		
		egen mean_sh = mean(s_ijt)
		
		gen elasticities10 = (_b[dsps]) / p10
		gen elasticities20 = (_b[dsps]) / p20
		gen elasticities30 = (_b[dsps]) / p30
		gen elasticities50 = (_b[dsps]) / p50
		gen elasticities90 = (_b[dsps]) / p90
		gen elasticitiesMean = (_b[dsps]) / mean_sh
		
		sum elastici*
